/*
 * Decompiled with CFR 0.152.
 */
package com.github.tartaricacid.netmusic.client.gui;

import com.github.tartaricacid.netmusic.client.config.MusicListManage;
import com.github.tartaricacid.netmusic.inventory.CDBurnerMenu;
import com.github.tartaricacid.netmusic.item.ItemMusicCD;
import com.github.tartaricacid.netmusic.network.NetworkHandler;
import com.github.tartaricacid.netmusic.network.message.SetMusicIDMessage;
import com.mojang.blaze3d.platform.InputConstants;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.minecraft.ChatFormatting;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.gui.components.Button;
import net.minecraft.client.gui.components.Checkbox;
import net.minecraft.client.gui.components.EditBox;
import net.minecraft.client.gui.components.events.GuiEventListener;
import net.minecraft.client.gui.screens.inventory.AbstractContainerScreen;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.FormattedText;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.inventory.AbstractContainerMenu;
import net.minecraft.world.item.ItemStack;
import org.anti_ad.mc.ipn.api.IPNIgnore;
import org.apache.commons.lang3.StringUtils;

@IPNIgnore
public class CDBurnerMenuScreen
extends AbstractContainerScreen<CDBurnerMenu> {
    private static final ResourceLocation BG = ResourceLocation.fromNamespaceAndPath((String)"netmusic", (String)"textures/gui/cd_burner.png");
    private static final Pattern ID_REG = Pattern.compile("^\\d{4,}$");
    private static final Pattern DJ_ID_REG = Pattern.compile("^dj/(\\d+)$");
    private static final Pattern URL_1_REG = Pattern.compile("^https://music\\.163\\.com/song\\?id=(\\d+).*$");
    private static final Pattern URL_2_REG = Pattern.compile("^https://music\\.163\\.com/#/song\\?id=(\\d+).*$");
    private static final Pattern DJ_URL_1_REG = Pattern.compile("^https://music\\.163\\.com/dj\\?id=(\\d+).*$");
    private static final Pattern DJ_URL_2_REG = Pattern.compile("^https://music\\.163\\.com/#/dj\\?id=(\\d+).*$");
    private EditBox textField;
    private Checkbox readOnlyButton;
    private Component tips = Component.empty();

    public CDBurnerMenuScreen(CDBurnerMenu screenContainer, Inventory inv, Component titleIn) {
        super((AbstractContainerMenu)screenContainer, inv, titleIn);
        this.imageHeight = 176;
    }

    protected void init() {
        super.init();
        String perText = "";
        boolean focus = false;
        if (this.textField != null) {
            perText = this.textField.getValue();
            focus = this.textField.isFocused();
        }
        this.textField = new EditBox(this, this.getMinecraft().font, this.leftPos + 12, this.topPos + 18, 132, 16, (Component)Component.literal((String)"Music ID Box")){

            public void insertText(String text) {
                Matcher matcher1 = URL_1_REG.matcher(text);
                if (matcher1.find()) {
                    String group = matcher1.group(1);
                    super.insertText(group);
                    return;
                }
                Matcher matcher2 = URL_2_REG.matcher(text);
                if (matcher2.find()) {
                    String group = matcher2.group(1);
                    super.insertText(group);
                    return;
                }
                Matcher matcher3 = DJ_URL_1_REG.matcher(text);
                if (matcher3.find()) {
                    String group = matcher3.group(1);
                    super.insertText("dj/" + group);
                    return;
                }
                Matcher matcher4 = DJ_URL_2_REG.matcher(text);
                if (matcher4.find()) {
                    String group = matcher4.group(1);
                    super.insertText("dj/" + group);
                    return;
                }
                super.insertText(text);
            }
        };
        this.textField.setValue(perText);
        this.textField.setBordered(false);
        this.textField.setMaxLength(19);
        this.textField.setTextColor(15986656);
        this.textField.setFocused(focus);
        this.textField.moveCursorToEnd(false);
        this.addWidget((GuiEventListener)this.textField);
        this.readOnlyButton = Checkbox.builder((Component)Component.translatable((String)"gui.netmusic.cd_burner.read_only"), (Font)this.font).pos(this.leftPos + 66, this.topPos + 34).maxWidth(80).selected(false).build();
        this.addRenderableWidget((GuiEventListener)this.readOnlyButton);
        this.addRenderableWidget((GuiEventListener)Button.builder((Component)Component.translatable((String)"gui.netmusic.cd_burner.craft"), b -> this.handleCraftButton()).pos(this.leftPos + 7, this.topPos + 35).size(55, 18).build());
    }

    private void handleCraftButton() {
        ItemStack cd = ((CDBurnerMenu)this.getMenu()).getInput().getStackInSlot(0);
        if (cd.isEmpty()) {
            this.tips = Component.translatable((String)"gui.netmusic.cd_burner.cd_is_empty");
            return;
        }
        ItemMusicCD.SongInfo songInfo = ItemMusicCD.getSongInfo(cd);
        if (songInfo != null && songInfo.readOnly) {
            this.tips = Component.translatable((String)"gui.netmusic.cd_burner.cd_read_only");
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.textField.getValue())) {
            this.tips = Component.translatable((String)"gui.netmusic.cd_burner.no_music_id");
            return;
        }
        Matcher djMatcher = DJ_ID_REG.matcher(this.textField.getValue());
        if (djMatcher.find()) {
            long djId = Long.parseLong(djMatcher.group(1));
            try {
                ItemMusicCD.SongInfo djSong = MusicListManage.getDjSong(djId);
                if (StringUtils.isBlank((CharSequence)djSong.songUrl) || StringUtils.isBlank((CharSequence)djSong.songName)) {
                    this.tips = Component.translatable((String)"gui.netmusic.cd_burner.get_info_error");
                    return;
                }
                djSong.readOnly = this.readOnlyButton.selected();
                NetworkHandler.sendToServer(new SetMusicIDMessage(djSong));
                return;
            }
            catch (Exception e) {
                this.tips = Component.translatable((String)"gui.netmusic.cd_burner.get_info_error");
                e.printStackTrace();
                return;
            }
        }
        if (ID_REG.matcher(this.textField.getValue()).matches()) {
            long id = Long.parseLong(this.textField.getValue());
            try {
                ItemMusicCD.SongInfo song = MusicListManage.get163Song(id);
                if (StringUtils.isBlank((CharSequence)song.songUrl) || StringUtils.isBlank((CharSequence)song.songName)) {
                    this.tips = Component.translatable((String)"gui.netmusic.cd_burner.get_info_error");
                    return;
                }
                song.readOnly = this.readOnlyButton.selected();
                NetworkHandler.sendToServer(new SetMusicIDMessage(song));
            }
            catch (Exception e) {
                this.tips = Component.translatable((String)"gui.netmusic.cd_burner.get_info_error");
                e.printStackTrace();
            }
        } else {
            this.tips = Component.translatable((String)"gui.netmusic.cd_burner.music_id_error");
        }
    }

    protected void renderLabels(GuiGraphics graphics, int x, int y) {
    }

    protected void renderBg(GuiGraphics graphics, float partialTicks, int x, int y) {
        int posX = this.leftPos;
        int posY = (this.height - this.imageHeight) / 2;
        graphics.blit(BG, posX, posY, 0, 0, this.imageWidth, this.imageHeight);
    }

    public void render(GuiGraphics graphics, int x, int y, float partialTicks) {
        super.render(graphics, x, y, partialTicks);
        this.textField.render(graphics, x, y, partialTicks);
        if (StringUtils.isBlank((CharSequence)this.textField.getValue()) && !this.textField.isFocused()) {
            graphics.drawString(this.font, (Component)Component.translatable((String)"gui.netmusic.cd_burner.id.tips").withStyle(ChatFormatting.ITALIC), this.leftPos + 12, this.topPos + 18, ChatFormatting.GRAY.getColor().intValue(), false);
        }
        graphics.drawWordWrap(this.font, (FormattedText)this.tips, this.leftPos + 8, this.topPos + 57, 135, 0xCF0000);
        this.renderTooltip(graphics, x, y);
    }

    public void resize(Minecraft minecraft, int width, int height) {
        String value = this.textField.getValue();
        super.resize(minecraft, width, height);
        this.textField.setValue(value);
    }

    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.textField.mouseClicked(mouseX, mouseY, button)) {
            this.setFocused((GuiEventListener)this.textField);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    public boolean keyPressed(int keyCode, int scanCode, int modifiers) {
        InputConstants.Key mouseKey = InputConstants.getKey((int)keyCode, (int)scanCode);
        if (this.getMinecraft().options.keyInventory.isActiveAndMatches(mouseKey) && this.textField.isFocused()) {
            return true;
        }
        return super.keyPressed(keyCode, scanCode, modifiers);
    }

    protected void insertText(String text, boolean overwrite) {
        if (overwrite) {
            this.textField.setValue(text);
        } else {
            this.textField.insertText(text);
        }
    }
}

